<?php

$plugins->add_hook("datahandler_post_validate_thread", "blothwibawor");
$plugins->add_hook("admin_config_menu", "blothwibawor_admin_nav");
$plugins->add_hook("admin_config_action_handler", "blothwibawor_action_handler");
$plugins->add_hook("admin_load", "blothwibawor_admin");

function blothwibawor_info()
{
	return array(
		"name"			=> "هاك الكلمات المحظورة",
		"description"	=> "يقوم بالسماح بوضع كلمات معينة يمنع اضافتها داخل الموضوع",
		"website"		=> "mailto:nicedo_eeos@hotmail.com",
		"author"		=> "Edson Ordaz",
		"authorsite"	=> "mailto:nicedo_eeos@hotmail.com",
		"version"		=> "1.0",
		"guid" 			=> "fecba92c0b6c23802e98abdc8679c806",
		"compatibility" => "16*"
	);
}


function blothwibawor_activate(){
	global $mybb, $db;
  	if(!$db->table_exists("blothwibawor"))
	{
		$db->query("CREATE TABLE IF NOT EXISTS `".TABLE_PREFIX."blothwibawor` (
  `blid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `badword` varchar(220) NOT NULL DEFAULT '',
  PRIMARY KEY (`blid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
	}
}

// This function runs when the plugin is deactivated.
function blothwibawor_deactivate(){
	global $mybb, $db;
		$db->drop_table("blothwibawor");
}

function blothwibawor_action_handler(&$action)
{
	$action['blothwibawor'] = array('active' => 'blothwibawor', 'file' => '');
}

function blothwibawor_admin_nav(&$sub_menu)
{
	global $mybb, $lang;
		$lang->load("config_blothwibawor", false, true);
		end($sub_menu);
		$key = (key($sub_menu))+10;
		
		if(!$key)
		{
			$key = '110';
		}
		
		$sub_menu[$key] = array('id' => $lang->name, 'title' => $lang->name, 'link' => "index.php?module=config-".$lang->name);

}

function blothwibawor_admin()
{
	global $mybb, $db, $page, $lang, $cache;

	if($page->active_action != $lang->name)
	{
		return;
	}
	$page->add_breadcrumb_item($lang->name);
	$page->output_header($lang->name);

if($mybb->input['action'] == "save") {

	$badword = array(
		'badword' => $db->escape_string($mybb->input['badword']),
	);

	$blid = $db->insert_query("blothwibawor", $badword);

		flash_message($lang->saved, 'success');
		admin_redirect("index.php?module=config-".$lang->name);

}
if($mybb->input['action'] == "add")
{
	$tabs[$lang->name] = array(
		'title' => $lang->name,
		'link' => "index.php?module=config-".$lang->name,
		'description' => $lang->name
	);
	$tabs[$lang->add] = array(
		'title' => $lang->add,
		'link' => "index.php?module=config-".$lang->name."&amp;action=add",
		'description' => $lang->add_des_tab
	);
	
	$page->output_nav_tabs($tabs,$lang->add);
	echo "<br />";
	$form = new Form("index.php?module=config-".$lang->name."&amp;action=save", "post");
	$form_container = new FormContainer($lang->name);
	
	$form_container->output_row($lang->title, $lang->titledescription, $form->generate_text_box('badword', $forum_cache[$mybb->input['fid']]['defaulttitle'], array('id' => 'badword')), 'badword');
	$form_container->end();

	$buttons[] = $form->generate_submit_button($lang->submit);
	$form->output_submit_wrapper($buttons);
	$form->end();
	$page->output_footer();
}
	$tabs[$lang->name] = array(
		'title' => $lang->name,
		'link' => "index.php?module=config-".$lang->name,
		'description' => $lang->des_tab_name
	);
	$tabs[$lang->add] = array(
		'title' => $lang->add,
		'link' => "index.php?module=config-".$lang->name."&amp;action=add",
		'description' => $lang->plug_log
	);
	$page->output_nav_tabs($tabs,$lang->name);
	
if($mybb->input['action'] == "save_edit") {

	$badword_edit = array(
		"badword" => $db->escape_string($mybb->input['badword_edit'])
	);
	$db->update_query("blothwibawor", $badword_edit,"blid='{$mybb->input['blid']}'");

		flash_message($lang->saved, 'success');
		admin_redirect("index.php?module=config-".$lang->name);

}
if($mybb->input['action'] == "edit") {
	$query = $db->simple_select("blothwibawor", "*", "blid='".intval($mybb->input['blid'])."'");
	$blothwibawor = $db->fetch_array($query);
	$form = new Form("index.php?module=config-".$lang->name."&amp;action=save_edit", "post");
	echo $form->generate_hidden_field("blid", $mybb->input['blid']);
	$form_container = new FormContainer("Editar la palabra");

	$form_container->output_row($lang->edit." palabra ".$blothwibawor[badword], $lang->edit_des, $form->generate_text_box('badword_edit', $blothwibawor[badword], array('id' => 'badword_edit')), 'badword_edit');
	$form_container->end();

	$buttons[] = $form->generate_submit_button($lang->submit);
	$form->output_submit_wrapper($buttons);
	$form->end();
		$page->output_footer();
}
if($mybb->input['action'] == "delete")
	{
		$query = $db->simple_select("blothwibawor", "*");
		$blothwibawor = $db->fetch_array($query);

		if(!$blothwibawor['blid'])
		{
			flash_message("Error", 'error');
			admin_redirect("index.php?module=forum/".$lang->url);
		}

		// User clicked no
		if($mybb->input['no'])
		{
			admin_redirect("index.php?module=forum/".$lang->url);
		}

		if($mybb->request_method == "post")
		{
			$db->query("DELETE FROM ".TABLE_PREFIX."blothwibawor WHERE blid='".intval($mybb->input['blid'])."'");
			flash_message($lang->saved_delete, 'error');
			admin_redirect("index.php?module=config-".$lang->name);
		}
		else
		{
			$page->output_confirm_action("index.php?module=forum/".$lang->url);
		}
	}
		$table = new Table;
		$table->construct_header($lang->badword, array("width" => "70%"));
		$table->construct_header($lang->blid, array("class" => "align_center", "width" => "10%"));
		$table->construct_header($lang->controls, array("class" => "align_center", "colspan" => 2, "width" => "20%"));
		$table->construct_row();

		$query = $db->simple_select("blothwibawor", "*", "");
		while($blothwibawor = $db->fetch_array($query))
		{
				$table->construct_cell($blothwibawor['badword']);
				$table->construct_cell($blothwibawor['blid'], array("class" => "align_center"));
				$table->construct_cell("<a href=\"index.php?module=config-".$lang->name."&amp;action=edit&amp;blid={$blothwibawor['blid']}\">".$lang->edit."</a>", array("class" => "align_center"));
				$table->construct_cell("<a href=\"index.php?module=config-".$lang->name."&amp;action=delete&amp;blid={$blothwibawor['blid']}&amp;my_post_key={$mybb->post_code}\" onclick=\"return AdminCP.deleteConfirmation(this, '{$lang->delete_onclick}')\">".$lang->delete."</a>", array("class" => "align_center"));
				$table->construct_row();
		}
		$table->output($lang->name);
		$page->output_footer();

}
function blothwibawor(&$this)
{
	global $mybb, $db, $posthandler;
	$message_chars = get_object_vars($this);
	$message_editor = $message_chars['data']['message'];
	$query_palabra = $db->query("SELECT badword FROM ".TABLE_PREFIX."blothwibawor");
	while($results = $db->fetch_array($query_palabra))
	{
		if(stristr($message_editor, $results[badword])){
			$posthandler->set_error("لا تستطيع اضافة الموضوع لان هناك كلمة ممنوعة داخل الموضوع يرجي حذفها وهي ".$results[badword]);
		}
	}
}
?>